﻿namespace Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary.Tests
{
    using System.ComponentModel.Composition.Hosting;
    using System.Linq;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight;
    using Microsoft.Samples.PlanMyNight.AddIns.EmailItinerary;
    using Microsoft.Samples.PlanMyNight.Infrastructure;
    using Microsoft.VisualStudio.TestTools.UnitTesting;

    [TestClass]
    public class ItineraryContextualActionsExportFixture
    {
        [TestMethod]
        public void ShouldExportMefConsumableMetadataForItineraryToolboxExtensionSite()
        {
            var catalog = new TypeCatalog(typeof(ItineraryContextualActionsExport));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<RouteValueDictionary>();

            Assert.AreEqual(1, actual.Count());
            var export = actual.ElementAt(0);
            Assert.AreEqual("EmailItinerary", export.Value["controller"]);
            Assert.AreEqual("GetEmailToolbox", export.Value["action"]);
        }

        [TestMethod]
        public void ShouldExportMefConsumableRouteForRenderingToolbox()
        {
            var catalog = new TypeCatalog(typeof(ItineraryContextualActionsExport));
            var container = new CompositionContainer(catalog);

            var actual = container.GetExports<ExtensionLink, IExtensionSiteMetadata>();

            Assert.AreEqual(1, actual.Count());
            var export = actual.ElementAt(0);
            Assert.AreEqual("ItineraryLinks", export.Metadata.TargetExtensionSite);
            Assert.AreEqual("Email", export.Value.LinkText);
        }
    }
}
